****************************************
* Exportation of wealth share for WID
****************************************

global projdir "C:/Users/John/Dropbox/WIDFrance/Papers"
global rawresultsB "$projdir/GGP2016Wealth/GGP2016WealthAppendixB/DataFiles/Exportation/Results"
global rawresultsC "$projdir/GGP2016Wealth/GGP2016WealthAppendixC/DataFiles"
global rawresultsDINAA "$projdir/GGP2017DINA/GGP2017DINAAppendixA"

/**************************
Relevant Notations
	a) Prefix
		o Top average 
		t threshold
		s share
		n number of the given units
		b betacoefficient
		a average between two percentiles
	*b) Sufix
		j equal split
		992 adults 
		hweal : personal wealth
************************************/

***************************
* I) Exportation of gperc *
***************************
	
	* A) Merge the data from Appendix B and Appendix C
	*******************************************************	
		* Total adult population for year 1800-1969
			import excel using "$rawresultsDINAA/GGP2017DINAAppendixA.xlsx",  clear sheet("A0") cellrange(A17:Q169) 
			gen year=A if _n>=9	
			destring year,replace
			replace  year=1795 if _n==1
			replace year=year[_n-1]+10 if _n>1 & _n<9
			gen pop=P*1000 
			keep year pop
			tempfile NA
			save "`NA'",replace
			
			clear
			set obs 215
			gen year=1799+_n
			merge 1:1 year using "`NA'"
			keep if year>=1805
			local i=1
			foreach num of numlist 1805(10)1855 1865 {
				local j=`i'+10
				if `num'==1865 {
					local j= `i'+5
				}
				sum pop if _n==`i'
				local ni =r(mean)
				sum pop if _n==`j'
				local nj=r(mean)
				replace pop=`ni'+(`nj'-`ni')*(_n-`i')/(`j'-`i') if _n<`j' & _n>`i'
				local i=`i'+10
			}
			drop _merge
			erase "`NA'"
			tempfile NA
			save "`NA'",replace
		
		* Period 1970-2014
			use "$rawresultsB/gperc/gperc_19702014.dta",clear
			keep if sex==0
			keep year ytop n gperc thr b patmean pop
			* top average
				rename ytop o 
			* Threshold
				rename thr t
			gen p2 =gperc
			replace p2=p2*10 if gperc<99990
			replace p2=p2*10 if gperc<9990
			replace p2=p2*10 if gperc<990
			drop gperc
			
			tempfile temp19702014
			save "`temp19702014'",replace

		* Period 1820-1969
			use "$rawresultsC/gperc_wealth_1800_1970.dta",clear
			merge m:1 year using "`NA'"
			drop if _merge==2
			drop _merge
			* Number of adults
				rename f n
				replace n=pop*n/100000
			* top average
				rename ytop_hweal_j o
			* Threshold
				rename ythr_hweal_j  t  
			* Pareto coefficient
				rename b_hweal_j b
			* Intermediate average
				rename yint_hweal_j  a
			* Percentile
				rename p p2
			bys year :egen patmean=sum(o*(p2==0))
			drop ythr_hweal_j_d yint_hweal_j_d ytop_hweal_j_d
			append using "`temp19702014'"
			erase "`temp19702014'"
			

	* B) Missing variables to compute
	**************************************
		* Pop above threshold
			gsort + year - p2
			bys year : gen npop =sum(n)
			bys year : egen ytot=sum(npop*o*(p2==0))
		* wealth share above threshold
			gen s=o*npop/ytot
		* Intermediate average wealth
			sort year p2
			replace a=(o*npop-o[_n+1]*npop[_n+1])/(npop-npop[_n+1]) if year==year[_n+1]  & a==.
			replace a =o if p2==99999
			replace a=(ythr+ythr[_n+1])/2 if (a>a[_n+1] | a<t) & p~=99999
		* Harmonization of percentile name
			gen ptemp=p2
			tostring ptemp,gen(ptemp2)
			drop p2
			gen p2="p"+substr(ptemp2,1,1) if ptemp<=9000
			replace p2="p"+substr(ptemp2,1,2) if ptemp<=99000 & p2==""
			replace p2="p"+substr(ptemp2,1,2)+"."+substr(ptemp2,3,1) if ptemp<=99900 & p2==""
			replace p2="p"+substr(ptemp2,1,2)+"."+substr(ptemp2,3,2) if ptemp<=99990 & p2==""
			replace p2="p"+substr(ptemp2,1,2)+"."+substr(ptemp2,3,3) if ptemp>99990 & p2==""

		gen alpha2="FR"
		foreach var of varlist o t s b a n {
			rename `var' `var'hweal992j
		}
		sort year ptemp
		keep alpha2 year p2  *hweal992j ptemp
		order alpha2 year p2  *hweal992j ptemp
		save "$projdir/GGP2016Wealth/WID_export/gpercwealthFR.dta",  replace
		
		insheet using "$projdir/GGP2016Wealth/WID_export/inyixx999i_FR.csv",clear  delimiter(";")
		drop p2
		merge 1:m year using "$projdir/GGP2016Wealth/WID_export/gpercwealthFR.dta"
		sum inyixx999i if year==1820
		replace inyixx999i=r(mean) if year<1820
		drop if _merge==1
		
		foreach var of varlist thweal992j ahweal992j ohweal992j {
			replace `var'=`var'*100*6.55957 if year==1950 | year==1949
			replace `var'=`var'/inyixx999i
		}
		sort  ptemp year
		drop ptemp _merge inyixx999i
		outsheet using "$projdir/GGP2016Wealth/WID_export/gpercwealthFR.csv",    delimiter(";") replace
		save "$projdir/GGP2016Wealth/WID_export/gpercwealthFR.dta",  replace


****************************************
* I) Exportation of wealth composition *
****************************************
	import excel using "$rawresultsB/exportresults_wealthcap.xlsx", first clear sheet("comptanat") cellrange(A7:D50) 
	merge 1:m year using "$rawresultsB/dperc/dperc_w.dta"
	keep if sex==0
	drop sex
	gen n=0.1 if dperc<=90
	replace n=0.05 if dperc==95
	replace n=0.01 if dperc==99
	replace n=0.005 if dperc==995
	replace n=0.001 if dperc==999
	
	* Wealth composition in % total wealth
		foreach var of varlist sh_patnonfi-sh_patfinhorsliqu {
			replace `var'=`var'*share_dperc
		}
	* Cumulative above P90
		gsort + year -dperc
		foreach var of varlist share_dperc-sh_patfinhorsliqu {
			bys year : gen `var'temp=sum(`var') 
			replace `var'=`var'temp if dperc>=90
			drop `var'temp
		}
		
	* Average wealth and its components by wealth group
		gen ahweal=share_dperc*wealth*1000000/(n*pop)
		foreach var of varlist sh_patnonfi-sh_patfinhorsliqu {
			replace `var'=`var'/share_dperc*ahweal
		}
	* Verif
		gen verif=ahweal-sh_patnonfi- sh_patfin+ sh_passif
		sum verif,d
		drop verif
	
	rename sh_patnonfi ahwnfa
	rename sh_patfon_brut ahwhou
	rename sh_patpro ahwbus
	rename sh_patfin ahwfin
	rename sh_patfin_liquint ahwfix
	rename sh_patfin_liqu ahwcud
	rename sh_patfin_int ahwbol
	rename sh_patfin_div ahwequ
	rename sh_patfin_av ahwpen
	rename sh_passif ahwdeb
	rename sh_patfinhorsliqu ahwfie
	keep year dperc a*
	
	sort year dperc
	gen dperctemp=dperc
	tostring dperc,replace
	gen alpha2="FR"
	gen p2="p"+dperc+"p"+dperc[_n+1] if dperctemp<90
	replace p2= "p"+dperc+"p100" if dperctemp>=90 & dperctemp<=99
	replace p2="p"+substr(dperc,1,2)+"."+substr(dperc,3,1)+"p100"  if dperctemp>99 & p2==""
	drop  dperc
	order alpha2 year p2 ahweal
	foreach var of varlist ahweal-ahwfie  {
			rename `var' `var'992j
	}
	sort year dperctemp
	save "$projdir/GGP2016Wealth/WID_export/wealthcompoFR.dta",  replace
	
	insheet using "$projdir/GGP2016Wealth/WID_export/inyixx999i_FR.csv",clear  delimiter(";")
	drop p2
	merge 1:m year using "$projdir/GGP2016Wealth/WID_export/wealthcompoFR.dta"
	drop if _merge==1
	drop _merge
	
	foreach var of varlist ahweal992j-ahwfie992j {
		replace `var'=`var'/inyixx999i
	}
	sort alpha2 dperctemp year
	drop inyixx999i dperctemp
	save "$projdir/GGP2016Wealth/WID_export/wealthcompoFR.dta",  replace
	outsheet using "$projdir/GGP2016Wealth/WID_export/wealthcompoFR.csv",    delimiter(";") replace
